-- Schichtzeiten auf Zeitraster
CREATE OR REPLACE FUNCTION ksv__b_iu__ksb_times_in_time_grid() RETURNS TRIGGER AS $$
    DECLARE

        _prefix varchar := 'TRIGGER ksv__b_iu__ksb_times_in_time_grid -';
        _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );
        _ksb_timestart time := new.ksb_timestart;
        _ksb_timeend   time := new.ksb_timeend;

        _adjusted boolean := false;

    BEGIN
        -- Debug
        IF _loglevel >= 5 THEN
            RAISE NOTICE '% ksb_id:%;', _prefix, new.ksb_id;
        END IF;
        -- Arbeitsbeginn
        IF new.ksb_timestart IS NOT null THEN
            IF new.ksb_timestart <> tsystem.timestamp__ceil_to_interval( _time => new.ksb_timestart, _time_grid => TSystem.Settings__GetInteger( 'scheduling.time_grid', 60 ) * interval '1 second' ) THEN
                new.ksb_timestart := tsystem.timestamp__ceil_to_interval( _time => new.ksb_timestart, _time_grid => TSystem.Settings__GetInteger( 'scheduling.time_grid', 60 ) * interval '1 second' );
                _adjusted := true;
                -- Debug
                IF _loglevel >= 5 THEN
                    RAISE NOTICE '% ksb_id:%, ksb_timestart adjusted: % -> % ;', _prefix, new.ksb_id, _ksb_timestart, new.ksb_timestart;
                END IF;
            END IF;
        END IF;
        -- Arbeitsende
        IF new.ksb_timeend IS NOT null THEN
            IF new.ksb_timeend <> tsystem.timestamp__floor_to_interval( _time => new.ksb_timeend, _time_grid => TSystem.Settings__GetInteger( 'scheduling.time_grid', 60 ) * interval '1 second' ) THEN
                new.ksb_timeend := tsystem.timestamp__floor_to_interval( _time => new.ksb_timeend, _time_grid => TSystem.Settings__GetInteger( 'scheduling.time_grid', 60 ) * interval '1 second' );
                _adjusted := true;
                -- Debug
                IF _loglevel >= 5 THEN
                    RAISE NOTICE '% ksb_id:%, ksb_timeend adjusted: % -> % ;', _prefix, new.ksb_id, _ksb_timeend, new.ksb_timeend;
                END IF;
            END IF;
        END IF;
        -- Prodat-Meldung
        IF _adjusted THEN
            PERFORM PRODAT_HINT( Message => lang_text( 32009 ) ); -- Meldung: Die eingegeben Schichtzeiten wurden auf das Zeitraster gerundet.
        END IF;
        --
        RETURN new;
    END $$ LANGUAGE plpgsql;
--
  DROP TRIGGER IF EXISTS ksv__b_iu__ksb_times_in_time_grid ON ksvba;
  CREATE TRIGGER ksv__b_iu__ksb_times_in_time_grid
      BEFORE INSERT OR UPDATE
      OF ksb_timestart, ksb_timeend
      ON ksvba
      FOR EACH ROW
      EXECUTE PROCEDURE ksv__b_iu__ksb_times_in_time_grid();
--